% Note: The gamma values in Table 3.1 are obtained with the settings below:
% Case 1: The optimal gamma 0.6233 is obtained by setting gamma as a decision variable
% Case 2: The other gamma values are obtained via setting gamma as constant, check feasiblity of observer design through trial and error


% weight
Cx = eye(n);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% gamma0 = sdpvar(1); % Case 1

% gamma0 = 31; % Case 2
gamma0 = 40; % Case 2, used to generate results in Figs.3.6 and 3.7
% gamma0 = 60; % Case 2

M0 = sdpvar(m,n);
P0 = sdpvar(n,n);

LMI1 = blkvar();
LMI1(1,1) = (A*P0+B*M0)+(A*P0+B*M0)';
LMI1(1,2) = D;
LMI1(1,3) = Mc;
LMI1(1,4) = P0*Nc';
LMI1(1,5) = P0*Cx';

LMI1(2,2) = -gamma0*eye(l);
LMI1(2,3) = zeros(l,n);
LMI1(2,4) = zeros(l,n);
LMI1(2,5) = zeros(l,n);

LMI1(3,3) = -eye(n);
LMI1(3,4) = zeros(n,n);
LMI1(3,5) = zeros(n,n);

LMI1(4,4) = -eye(n);
LMI1(4,5) = zeros(n,n);

LMI1(5,5) = -gamma0*eye(n);

LMI1 = sdpvar(LMI1);


% objective = gamma0;  % Case 1
objective = [];  % Case 2

const = [];
% const = [const, gamma0 >= 0]; % Case 1
const = [const, P0 >= eps*eye(n)];
const = [const, LMI1 <= -eps*eye(4*n+l)];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5
ops = sdpsettings('solver','mosek','verbose','1');

optimize(const,objective,ops);

K =  value(M0)*inv(value(P0))
gamma = value(gamma0)
P = value(P0)

% test
eig_Ac = eig(A + B*K)


